/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.FunctionAvailabilityCache$Version;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.StaticGLInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;

public final class FunctionAvailabilityCache {
    private static final boolean DEBUG = Debug.debug("FunctionAvailabilityCache");
    private HashMap availabilityCache = new HashMap(50);
    private HashSet availableExtensionCache = new HashSet(50);
    private GLContextImpl context;

    FunctionAvailabilityCache(GLContextImpl gLContextImpl) {
        this.context = gLContextImpl;
    }

    public final void flush() {
        this.availabilityCache.clear();
        this.availableExtensionCache.clear();
    }

    public final boolean isFunctionAvailable(String string) {
        Boolean bl;
        if (DEBUG) {
            System.err.println("!!! CHECKING FOR AVAILABILITY OF: " + string);
        }
        if ((bl = (Boolean)this.availabilityCache.get(string)) == null) {
            bl = this.isPartOfAvailableExtensions(string) || FunctionAvailabilityCache.isPartOfGLCore(this.context.getGL().glGetString(7938), string) ? Boolean.TRUE : Boolean.FALSE;
            this.availabilityCache.put(string, bl);
        }
        if (DEBUG) {
            System.err.println("!!! AVAILABILITY OF " + string + ": " + bl);
        }
        return bl;
    }

    public final boolean isExtensionAvailable(String string) {
        this.initAvailableExtensions();
        return this.availableExtensionCache.contains(FunctionAvailabilityCache.mapGLExtensionName(string));
    }

    protected final void initAvailableExtensions() {
        if (this.availableExtensionCache.isEmpty()) {
            Object object;
            GL gL = this.context.getGL();
            if (DEBUG) {
                System.err.println("!!! Pre-caching extension availability");
            }
            Object object2 = gL.glGetString(7939) + " " + this.context.getPlatformExtensionsString();
            if (DEBUG) {
                System.err.println("!!! Available extensions: " + (String)object2);
                System.err.println("!!! GL vendor: " + gL.glGetString(7936));
            }
            object2 = new StringTokenizer((String)object2);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim().intern();
                this.availableExtensionCache.add(object);
                if (!DEBUG) continue;
                System.err.println("!!!   Available: " + (String)object);
            }
            object = new FunctionAvailabilityCache$Version(gL.glGetString(7938));
            int n2 = ((FunctionAvailabilityCache$Version)object).getMinor();
            for (int i2 = ((FunctionAvailabilityCache$Version)object).getMajor(); i2 > 0; --i2) {
                while (n2 >= 0) {
                    this.availableExtensionCache.add("GL_VERSION_" + i2 + "_" + n2);
                    if (DEBUG) {
                        System.err.println("!!! Added GL_VERSION_" + i2 + "_" + n2 + " to known extensions");
                    }
                    --n2;
                }
                switch (i2) {
                    case 2: {
                        n2 = 5;
                    }
                }
            }
            this.availableExtensionCache.add("<INTERNAL_DUMMY_PLACEHOLDER>");
        }
    }

    protected final boolean isPartOfAvailableExtensions(String string) {
        this.initAvailableExtensions();
        string = FunctionAvailabilityCache.getExtensionCorrespondingToFunction(string);
        return this.availableExtensionCache.contains(string);
    }

    public static boolean isPartOfGLCore(String string, String string2) {
        FunctionAvailabilityCache$Version functionAvailabilityCache$Version;
        FunctionAvailabilityCache$Version functionAvailabilityCache$Version2;
        String string3 = StaticGLInfo.getFunctionAssociation(string2);
        if (string3 == null) {
            throw new GLException("Function \"" + string2 + "\" does not correspond to any known OpenGL extension or core version.");
        }
        try {
            functionAvailabilityCache$Version2 = new FunctionAvailabilityCache$Version(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        try {
            functionAvailabilityCache$Version = new FunctionAvailabilityCache$Version(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Illegally formatted OpenGL version identifier: \"" + string + "\"");
        }
        if (functionAvailabilityCache$Version2.compareTo(functionAvailabilityCache$Version) <= 0) {
            if (DEBUG) {
                System.err.println(string2 + " is in core OpenGL " + string + " because it is in OpenGL " + string3);
            }
            return true;
        }
        if (DEBUG) {
            System.err.println(string2 + " is NOT a part of the OpenGL " + string + " core; it is part of OpenGL " + string3);
        }
        return false;
    }

    protected static String getExtensionCorrespondingToFunction(String string) {
        return FunctionAvailabilityCache.mapGLExtensionName(StaticGLInfo.getFunctionAssociation(string));
    }

    private static String mapGLExtensionName(String string) {
        if (string != null && (string.equals("WGL_NV_vertex_array_range") || string.equals("GLX_NV_vertex_array_range"))) {
            return "GL_NV_vertex_array_range";
        }
        return string;
    }
}

