/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.FileInputStream;
import java.io.InputStream;

class DecodeExample {
    static int convsize = 8192;
    static byte[] convbuffer = new byte[8192];

    DecodeExample() {
    }

    public static void main(String[] object) {
        InputStream inputStream = System.in;
        if (((String[])object).length > 0) {
            try {
                inputStream = new FileInputStream(object[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        object = new SyncState();
        StreamState streamState = new StreamState();
        Page page = new Page();
        Packet packet = new Packet();
        Info info = new Info();
        Comment comment = new Comment();
        DspState dspState = new DspState();
        Block block = new Block(dspState);
        int n2 = 0;
        ((SyncState)object).init();
        while (true) {
            boolean bl = false;
            int n3 = ((SyncState)object).buffer(4096);
            byte[] byArray = ((SyncState)object).data;
            try {
                n2 = inputStream.read(byArray, n3, 4096);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(-1);
            }
            ((SyncState)object).wrote(n2);
            if (((SyncState)object).pageout(page) != 1) {
                if (n2 < 4096) break;
                System.err.println("Input does not appear to be an Ogg bitstream.");
                System.exit(1);
            }
            streamState.init(page.serialno());
            info.init();
            comment.init();
            if (streamState.pagein(page) < 0) {
                System.err.println("Error reading first page of Ogg bitstream data.");
                System.exit(1);
            }
            if (streamState.packetout(packet) != 1) {
                System.err.println("Error reading initial header packet.");
                System.exit(1);
            }
            if (info.synthesis_headerin(comment, packet) < 0) {
                System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
                System.exit(1);
            }
            int n4 = 0;
            while (n4 < 2) {
                int n5;
                while (n4 < 2 && (n5 = ((SyncState)object).pageout(page)) != 0) {
                    if (n5 != 1) continue;
                    streamState.pagein(page);
                    while (n4 < 2 && (n5 = streamState.packetout(packet)) != 0) {
                        if (n5 == -1) {
                            System.err.println("Corrupt secondary header.  Exiting.");
                            System.exit(1);
                        }
                        info.synthesis_headerin(comment, packet);
                        ++n4;
                    }
                }
                n3 = ((SyncState)object).buffer(4096);
                byArray = ((SyncState)object).data;
                try {
                    n2 = inputStream.read(byArray, n3, 4096);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    System.exit(1);
                }
                if (n2 == 0 && n4 < 2) {
                    System.err.println("End of file before finding all Vorbis headers!");
                    System.exit(1);
                }
                ((SyncState)object).wrote(n2);
            }
            Object object2 = comment.user_comments;
            for (int i2 = 0; i2 < ((byte[][])object2).length && object2[i2] != null; ++i2) {
                System.err.println(new String(object2[i2], 0, object2[i2].length - 1));
            }
            System.err.println("\nBitstream is " + info.channels + " channel, " + info.rate + "Hz");
            System.err.println("Encoded by: " + new String(comment.vendor, 0, comment.vendor.length - 1) + "\n");
            convsize = 4096 / info.channels;
            dspState.synthesis_init(info);
            block.init(dspState);
            object2 = new float[1][][];
            int[] nArray = new int[info.channels];
            while (!bl) {
                int n6;
                while (!bl && (n6 = ((SyncState)object).pageout(page)) != 0) {
                    if (n6 == -1) {
                        System.err.println("Corrupt or missing data in bitstream; continuing...");
                        continue;
                    }
                    streamState.pagein(page);
                    while ((n6 = streamState.packetout(packet)) != 0) {
                        if (n6 == -1) continue;
                        if (block.synthesis(packet) == 0) {
                            dspState.synthesis_blockin(block);
                        }
                        while ((n6 = dspState.synthesis_pcmout((float[][][])object2, nArray)) > 0) {
                            byte[] byArray2 = object2[0];
                            n6 = n6 < convsize ? n6 : convsize;
                            for (n4 = 0; n4 < info.channels; ++n4) {
                                int n7 = n4 << 1;
                                int n8 = nArray[n4];
                                for (int i3 = 0; i3 < n6; ++i3) {
                                    int n9 = (int)((double)byArray2[n4][n8 + i3] * 32767.0);
                                    if (n9 > Short.MAX_VALUE) {
                                        n9 = Short.MAX_VALUE;
                                    }
                                    if (n9 < Short.MIN_VALUE) {
                                        n9 = Short.MIN_VALUE;
                                    }
                                    if (n9 < 0) {
                                        n9 |= 0x8000;
                                    }
                                    DecodeExample.convbuffer[n7] = (byte)n9;
                                    DecodeExample.convbuffer[n7 + 1] = (byte)(n9 >>> 8);
                                    n7 += 2 * info.channels;
                                }
                            }
                            System.out.write(convbuffer, 0, 2 * info.channels * n6);
                            dspState.synthesis_read(n6);
                        }
                    }
                    if (page.eos() == 0) continue;
                    bl = true;
                }
                if (bl) continue;
                int n10 = ((SyncState)object).buffer(4096);
                byte[] byArray3 = ((SyncState)object).data;
                try {
                    n2 = inputStream.read(byArray3, n10, 4096);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    System.exit(1);
                }
                ((SyncState)object).wrote(n2);
                if (n2 != 0) continue;
                bl = true;
            }
            streamState.clear();
            block.clear();
            dspState.clear();
            info.clear();
        }
        ((SyncState)object).clear();
        System.err.println("Done.");
    }
}

