/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.VorbisFile;

class ChainingExample {
    ChainingExample() {
    }

    public static void main(String[] object) {
        try {
            object = new VorbisFile(System.in, null, -1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
        if (((VorbisFile)object).seekable()) {
            System.out.println("Input bitstream contained " + ((VorbisFile)object).streams() + " logical bitstream section(s).");
            System.out.println("Total bitstream playing time: " + ((VorbisFile)object).time_total(-1) + " seconds\n");
        } else {
            System.out.println("Standard input was not seekable.");
            System.out.println("First logical bitstream information:\n");
        }
        for (int i2 = 0; i2 < ((VorbisFile)object).streams(); ++i2) {
            Object object2 = ((VorbisFile)object).getInfo(i2);
            System.out.println("\tlogical bitstream section " + (i2 + 1) + " information:");
            System.out.println("\t\t" + ((Info)object2).rate + "Hz " + ((Info)object2).channels + " channels bitrate " + ((VorbisFile)object).bitrate(i2) / 1000 + "kbps serial number=" + ((VorbisFile)object).serialnumber(i2));
            System.out.print("\t\tcompressed length: " + ((VorbisFile)object).raw_total(i2) + " bytes ");
            System.out.println(" play time: " + ((VorbisFile)object).time_total(i2) + "s");
            object2 = ((VorbisFile)object).getComment(i2);
            System.out.println(object2);
        }
    }
}

